(function () {
	var registry =
		(window.wc && (window.wc.blocksRegistry || window.wc.wcBlocksRegistry)) ||
		window.wcBlocksRegistry;
	if (!registry || typeof registry.registerPaymentMethod !== "function") {
		return;
	}

	var registerPaymentMethod = registry.registerPaymentMethod;
	var createElement =
		(window.wp && window.wp.element && window.wp.element.createElement) ||
		function () {
			return null;
		};

	var labelNode = (function () {
		if (
			typeof FinmoBlocksSettings !== "undefined" &&
			FinmoBlocksSettings.logoUrl
		) {
			return createElement(
				"div",
				{
					style: {
						display: "flex",
						alignItems: "center",
						gap: "15px",
						padding: "10px 0",
					},
				},
				[
					createElement(
						"div",
						{
							style: {
								display: "flex",
								alignItems: "center",
								gap: "10px",
							},
						},
						[
							createElement(
								"span",
								{
									style: {
										fontWeight: "600",
										fontSize: "16px",
										color: "#333",
									},
								},
								"Finmo Payments"
							),
							createElement("img", {
								src: FinmoBlocksSettings.logoUrl,
								alt: "Finmo",
								style: {
									height: "60px",
									width: "auto",
									verticalAlign: "middle",
								},
							}),
						]
					),
				]
			);
		}
		return "Finmo Payments";
	})();

	registerPaymentMethod({
		name: "finmo_payments",
		label: labelNode,
		ariaLabel: "Finmo Payments",
		content: createElement(
			"div",
			null,
			"Supports most instant payment methods and bank transfers | Powered by Finmo"
		),
		edit: createElement("div", null, "Finmo Payments"),
		canMakePayment: function () {
			return true;
		},
		supports: { features: ["products", "refunds"] },
		onSubmit: function (paymentData, actions) {
			// Redirect user to Finmo checkout URL
			console.log(paymentData);
			if (paymentData && paymentData.redirect) {
				window.location.href = paymentData.redirect;
			}
			return Promise.resolve({ result: "success" });
		},
	});
})();
